/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JLayeredPane;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.RootPaneContainer;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.TimerQueue;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

public class JApplet
extends Applet
implements Accessible,
RootPaneContainer {
    private static final BorderLayout sharedBorderLayout = new BorderLayout();
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext;
    static /* synthetic */ Class class$com$sun$java$swing$RootPaneContainer;

    public JApplet() {
        this.setLayout(sharedBorderLayout);
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
    }

    public void addNotify() {
        super.addNotify();
        this.enableEvents(8L);
        if (SwingUtilities.getAncestorOfClass(class$com$sun$java$swing$RootPaneContainer != null ? class$com$sun$java$swing$RootPaneContainer : (class$com$sun$java$swing$RootPaneContainer = JApplet.class$("com.sun.java.swing.RootPaneContainer")), this) == null) {
            TimerQueue.initAppletTimer(this);
        }
        this.setVisible(true);
    }

    public void removeNotify() {
        super.removeNotify();
        TimerQueue.removeAppletTimer(this);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            JComponent.processKeyBindingsForAllComponents(keyEvent, this, new Vector(), keyEvent.getID() == 401);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.getRootPane().setMenuBar(jMenuBar);
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
                return;
            }
            finally {
                Object var4_3 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
        }
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJApplet();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleJApplet
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FRAME;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = SwingUtilities.getAccessibleStateSet(JApplet.this);
            accessibleStateSet.add(AccessibleState.ACTIVE);
            return accessibleStateSet;
        }

        public Accessible getAccessibleParent() {
            Container container = JApplet.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(JApplet.this);
        }

        public int getAccessibleChildrenCount() {
            return SwingUtilities.getAccessibleChildrenCount(JApplet.this);
        }

        public Accessible getAccessibleChild(int n) {
            return SwingUtilities.getAccessibleChild(JApplet.this, n);
        }

        public Locale getLocale() {
            return JApplet.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return JApplet.this.getBackground();
        }

        public void setBackground(Color color) {
            JApplet.this.setBackground(color);
        }

        public Color getForeground() {
            return JApplet.this.getForeground();
        }

        public void setForeground(Color color) {
            JApplet.this.setForeground(color);
        }

        public Cursor getCursor() {
            return JApplet.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            JApplet.this.setCursor(cursor);
        }

        public Font getFont() {
            return JApplet.this.getFont();
        }

        public void setFont(Font font) {
            ((Component)JApplet.this).setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return JApplet.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return JApplet.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
            JApplet.this.setEnabled(bl);
        }

        public boolean isVisible() {
            return JApplet.this.isVisible();
        }

        public void setVisible(boolean bl) {
            JApplet.this.setVisible(bl);
        }

        public boolean isShowing() {
            return JApplet.this.isShowing();
        }

        public boolean contains(Point point) {
            return JApplet.this.contains(point);
        }

        public Point getLocationOnScreen() {
            return JApplet.this.getLocationOnScreen();
        }

        public Point getLocation() {
            return JApplet.this.getLocation();
        }

        public void setLocation(Point point) {
            JApplet.this.setLocation(point);
        }

        public Rectangle getBounds() {
            return JApplet.this.getBounds();
        }

        public void setBounds(Rectangle rectangle) {
            JApplet.this.setBounds(rectangle);
        }

        public Dimension getSize() {
            return JApplet.this.getSize();
        }

        public void setSize(Dimension dimension) {
            JApplet.this.setSize(dimension);
        }

        public Accessible getAccessibleAt(Point point) {
            return SwingUtilities.getAccessibleAt(JApplet.this, point);
        }

        public boolean isFocusTraversable() {
            return JApplet.this.isFocusTraversable();
        }

        public void requestFocus() {
            JApplet.this.requestFocus();
        }

        public void addFocusListener(FocusListener focusListener) {
            JApplet.this.addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            JApplet.this.removeFocusListener(focusListener);
        }

        AccessibleJApplet() {
            JApplet.this = JApplet.this;
        }
    }
}

